﻿/*	VERSION:	1.2
1.2		Made the tag-search recursive
	
DESCRIPTION:
	This is a handy function.  After loading an XML file, 
	use this to locate a specific tag so you can read its attributes.

WHAT IT'S FOR:
	This searches an XML object for the specified tag, and returns a reference to that tag.
	
USAGE:
	#include "findXmlTag.as"
	myData_xml = findXmlTag( "myTag", my_xml );
	
WHAT IT IS:
	A function containing a search loop.
	It returns an XMLNode reference to the data it's asked to find.
	If it does not find the tag you want, it naturally returns "undefined"
*/



findXmlTag = function( findThis_str, inThis_xml ){
	
	// if the starting XML node is what you're searching for  =>  output the starting XML node
	if( inThis_xml.nodeName === findThis_str )		return inThis_xml;
	
	// search inside this XML node
	for(var i=0; i<inThis_xml.childNodes.length; i++){
		var child_xml = inThis_xml.childNodes[i];
		// if this child XML node is what you're searching for  =>  output the child XML node
		var result = findXmlTag( findThis_str, child_xml );
		if(result)		return result;
		// else,  continue searching all children
	}// for each of the childNodes inside of inThis_xml
	
	// nothing was found
	return null;
	
}// findXmlTag()